#include "core.h"
#include "process.h"
#include "master.h"
#include "dbmonitor/dbdsp32.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "dbmon.h"
#include "dsp32core.h"
#include "dsp32dbmon.h"
#include "symbol.h"
#include "bpts.h"
SRCFILE("dsp32dbmon.c")

Process	*Dsp32DbmonMaster::newProcess(Process *pr, char *p, char *s, char* c)
{
	return new Dsp32DbmonProcess(fd, boardid, pipeid, pr, p, s, c);
}

char *Dsp32DbmonMaster::proctype()
{
	DebugAttrib dba;

	::dbrequest(fd, boardid, DB_KERNELID, DBR_GETATTRIB, (int)&dba,
		0, sizeof(dba));
	db_ntohsa(&dba.machine, 3);
	 return (dba.machine == DBMT_DSP32) ? "Dsp32" : "Dsp32c";
}

Dsp32DbmonProcess::Dsp32DbmonProcess(int f, int b, int pid, Process *sib,
  char *p, char *s, char *c) : DbmonProcess(f, b, pid, sib, p, s, c) {}

Core *Dsp32DbmonProcess::newCore(int f, int b, int p, Master *m)
{
	return new Dsp32DbmonCore(f, b, p, this, m);
}

Dsp32DbmonCore::Dsp32DbmonCore(int f, int b, int p, Process *pr, Master *m):
  Core(pr,m), DbmonCore(f,b,p)
{
	if (attrib.machine == DBMT_DSP32C)
		dsp32c = 1;
	regsize = sizeof(DebugRegs);
}

char *Dsp32DbmonCore::dumppipeline()	{ return dbreq(DBR_DUMPPIPE); }

char *Dsp32DbmonCore::liftbpt(Trap *t)	
{
	if( behavs() == ERRORED ) return 0;
	return dbreq(DBR_LIFTBKPT, 0, (int)t->stmt->range.lo);
}

char *Dsp32DbmonCore::faultname(int code)
{
	 return sf("Exited with status %d", code);
}
